<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

//default time zone. If set in cms it will overwrite this. If you remove this line the date function will return warnings.
date_default_timezone_set('Europe/Bucharest');

define("STP_GLOBAL_PROTOCOL"				, "");		// http | https , if empty uses the setting in the cms. Usefull if set the wrong protocol and cant access the cms anymore.
define("STP_LAYOUT_GRID"					, "BS4");	// if set to bs3 will use the grid values ([var]_desktop,[var]_tablet,[var]_phone ) else ([var]_xl,[var]_lg...)

//page title block & module head for all modules
define("STP_PAGEHEADER_NO_WIDTHS"			, "0");		// no width controls 
define("STP_PAGEHEADER_NO_CSS"				, "0");		// no extra css classes for block or elements
define("STP_PAGEHEADER_NO_SUBTITLE"			, "0");		// no subtitle field
define("STP_PAGEHEADER_NO_ALIGN"			, "0");		// no align field
define("STP_PAGEHEADER_NO_SNIPET"			, "0");		// no align field


//if any of the following variables came disabled by default, the current build wasnt designed to use those features and might cause instability
define("STP_MENUMANAGER_NO_DROP"			, "0");		// disables dropdown support in menu manager
define("STP_MENUMANAGER_NO_DROP_RESOURCE"	, "0");		// disables resources for drop menus ( images , raw html )
define("STP_MENUMANAGER_NO_MEGADROP"		, "0");		// disables mega drop menus
define("STP_MENUMANAGER_NO_GLOBALMODULE"	, "0");		// disables usage of global modules in menus

//widgets module
define("STP_WIDGETS_NO_OPTIONAL_CONTENT"	, "0");		// no optional fields for all widgets ( header / footer / 2 links )

//cms options
define("STP_DISABLE_CATEGORIES"				, "0");		//disabled categories / dropdown support for entire cms
define("STP_DISABLE_MODULE_LAYOUTS"			, "0");		//removes the layouts tab from manage pages
define("STP_SHOW_STATS"						, "0");		//enable to see stats at the bottomom the page ( php executin tiome / queries / used memmory )
define("STP_ENABLE_DEMO"					, "0");		//by activating the following will let anyone enter the cms and see it without loggin in, no operations will be performed over the database in CMS
define("STP_ENABLE_ONEPAGE"					, "0");		//removes certain incompatibilities with onepage so we can keep the same module for onepage and multiplage

define("STP_ENABLE_FULLPAGE"				, "1");		//enables fullpage scroller support in layouts, its not recommanded as its experimental and buggy


//engine settings, 
if ($_ADMIN) {
	define("_3RDPARTY"	 ,"./3rdparty/");			//plugins from other sources
	define("_LIBPATH"	 ,"./lib/");				//framework location
	define("_TPLPATH"	 , "./assets/");			//template and resources for cms interface
	define("_UPLOADPATH" , "../upload/");			//upload folder for public area
} else {
	define("_3RDPARTY"	 ,"./admin/3rdparty/");	
	define("_UPLOADPATH" , "./upload/");

	if (!defined("_LIBPATH")) 
		define("_LIBPATH","./admin/lib/");
	if (!defined("_MODPATH")) 
		define("_MODPATH","./admin/modules/");			
}


$start_mem = memory_get_usage();
$start_time = microtime(true);


//temporary fix for magic quotes
if (function_exists("get_magic_quotes_gpc") && get_magic_quotes_gpc()) {
    $process = array(&$_GET, &$_POST, &$_COOKIE, &$_REQUEST);
    while (list($key, $val) = each($process)) {
        foreach ($val as $k => $v) {
            unset($process[$key][$k]);
            if (is_array($v)) {
                $process[$key][stripslashes($k)] = $v;
                $process[] = &$process[$key][stripslashes($k)];
            } else {
                $process[$key][stripslashes($k)] = stripslashes($v);
            }
        }
    }
    unset($process);
}


//if executed as a wepage load the custom errors handler
if (!defined("CLI")) {
	require_once _LIBPATH . "error/error.php";	
} else {
	error_reporting(E_ERROR | E_WARNING | E_PARSE | E_DEPRECATED);
}

//fix https for servers that doesnt report it well
global $HTTPS;
if (strtoupper($_SERVER["HTTPS"]) == "ON") {
	$HTTPS = true;
} else {
	$HTTPS = false;
}


// this is suposed to be a bug fix for those IIS servers which doesnt know what is , its an old fix
if (!isset($_SERVER["REQUEST_URI"])) {
	$_SERVER["REQUEST_URI"] = 
			($HTTPS ? "https://" :  "http://") . 
			$_SERVER["SERVER_NAME"] . $_SERVER["SCRIPT_NAME"] . 	
			($_SERVER["QUERY_STRING"] ? '?' . $_SERVER["QUERY_STRING"] : '' );
}


require_once _LIBPATH . "site.php";


$site = new CSite(
	($_ADMIN ? "" : "admin/") . "site.xml",
	$_ADMIN , 
	true
);


//activate kcfinder support and pass the paths thru sessions.
if ($_ADMIN) {
	$base_root = $HTTPS ? 'https' : 'http';
	$base_url = $base_root .= '://'. preg_replace('/[^a-z0-9-:._]/i', '', $_SERVER['HTTP_HOST']);
	if ($dir = trim(dirname($_SERVER['SCRIPT_NAME']), '\,/')) {
		$base_path = "/$dir";
		$base_url .= $base_path;
	}

	if ($_ADMIN) {
		$base_url = dirname($base_url);
	}

	$_SESSION['KCFINDER'] = array(
		//activate browser only if logged in 
		'disabled' => is_array($_SESSION["store"]["minibase"]["raw"]) ? false : true,
		'uploadURL' => $base_url,
		'uploadDir' => dirname(__DIR__ . "/") . "/"
	);
}


$site->Run();

$end_time = microtime(true);

function convert($size) {
     $unit=array('b','kb','mb','gb','tb','pb');
     return @round($size/pow(1024,($i=floor(log($size,1024)))),2).' '.$unit[$i];
}


//performance stats
if (STP_SHOW_STATS && ($_PAGE != "ajax") && ($_PAGE != "json") && !$_ADMIN) {

	$stats = array(
		"PHP Execution Time"		=> (($end_time - $start_time))  . " seconds",
		"Queries Number"			=> $site->db->NumQueries(),
		"Queries Execution Time"	=> $site->db->queries_runtime  . " seconds",
		"Memory Usage"				=> convert(memory_get_usage() - $start_mem  )		
	);

	if (defined("CLI")) {
		echo "\n\n==== SUMMARY ===\n\n";
	} else {
		echo "<div style='display: block; height: auto;'>
				<div style='border-top: 2px solid #6a7888; padding: 15px 0px 0px;position: fixed; bottom: 0; width: 100%; background: #fff'>
					<center>
						<pre style='margin-bottom: 0'>";
	}

	foreach ($stats as $key => $val) {
		echo "{$key}: {$val}\n";
	}

	if (defined("CLI")) {
		echo "\n\n";
	} else {
		echo "			</pre>
					</center>
				</div>
			</div>";
	}
}

?>